﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="Activities.ascx.cs" Inherits="GUI.Controls.Activities" %>
<asp:HiddenField ID="hdnIsFinishedCombo" runat="server" />
<telerik:RadAjaxPanel ID="RadAjaxPanel1" runat="server" EnableAJAX="true" LoadingPanelID="RadAjaxLoadingPanel1">
<telerik:RadGrid ID="grdList" GroupingSettings-CaseSensitive="false" runat="server" PageSize="5" AllowFilteringByColumn="true" AutoPostBackOnFilter="true" CssClass="kendo-table" Skin="Bootstrap"
    EnableViewState="true" OnItemCommand="grdList_OnItemCommand" AllowPaging="true" AllowSorting="true"
    OnNeedDataSource="grdList_OnNeedDataSource" OnColumnCreating="grdList_OnColumnCreating" OnPreRender="grdList_PreRender">
    <PagerStyle Mode="NextPrevAndNumeric" />
    <MasterTableView ShowHeadersWhenNoRecords="true" TableLayout="Auto"  CssClass="table table-striped table-hover" ShowFooter="False"
        AutoGenerateColumns="False" DataKeyNames="Id">
        <Columns>
            
            <telerik:GridBoundColumn UniqueName="NameColumn" AutoPostBackOnFilter="true" CurrentFilterFunction="Contains"
                SortExpression="Name" ShowFilterIcon="false" HeaderText="<%$ Resources:ProjectManagementUI, Common_Name %>" DataField="Name" />
            
            <telerik:GridBoundColumn UniqueName="ProjectColumn" HeaderStyle-Width="150" AutoPostBackOnFilter="true"
                CurrentFilterFunction="Contains" SortExpression="Project.Name" ShowFilterIcon="false"
                HeaderText="<%$ Resources:ProjectManagementUI, Common_Project %>" DataField="Project.Name" />
			
            <telerik:GridBoundColumn UniqueName="StartDateColumn" HeaderStyle-Width="70" AutoPostBackOnFilter="true"
                CurrentFilterFunction="Contains" SortExpression="StartDateLocalized" ShowFilterIcon="false"
                HeaderText="<%$ Resources:ProjectManagementUI, Common_Start %>" DataField="StartDateLocalized" />
			
            <telerik:GridBoundColumn UniqueName="EndDateColumn" HeaderStyle-Width="70" AutoPostBackOnFilter="true"
                CurrentFilterFunction="Contains" SortExpression="EndDateLocalized" ShowFilterIcon="false"
                HeaderText="<%$ Resources:ProjectManagementUI, Common_End %>" DataField="EndDateLocalized" />
			
            <telerik:GridTemplateColumn AllowFiltering="false" HeaderStyle-Width="70" HeaderText="<%$ Resources:ProjectManagementUI, Common_PriorityShort %>" UniqueName="PriorityColumn" AutoPostBackOnFilter="true" CurrentFilterFunction="StartsWith" SortExpression="EnumPriority.NameLocalized" >
				<ItemTemplate>
                    <i class="fa fa-arrow-circle-<%#(Eval("EnumPriority.Name").ToString() == "Medium" ? "right font-kendo-yellow" : "")%><%#(Eval("EnumPriority.Name").ToString() == "High" ? "up font-kendo-red" : "")%><%#(Eval("EnumPriority.Name").ToString() == "Low" ? "down font-kendo-green" : "")%>"></i>
				</ItemTemplate>
				<ItemStyle HorizontalAlign="Center" VerticalAlign="Middle" />
			</telerik:GridTemplateColumn>
            
            <telerik:GridTemplateColumn DataField="IsClosed" AllowFiltering="true" HeaderStyle-Width="95" HeaderText="<%$ Resources:ProjectManagementUI, UI_Finished %>" UniqueName="IsClosed" AutoPostBackOnFilter="false" CurrentFilterFunction="EqualTo" SortExpression="IsClosed" >
				<ItemTemplate>
                    <i class="fa fa-1x fa-<%# (Eval("IsClosed").ToString() == "True") ? "check-square font-kendo-green" : "check-square font-kendo-red" %>"></i>  
				</ItemTemplate>
				<ItemStyle HorizontalAlign="Center" VerticalAlign="Middle" />
                <FilterTemplate>
                            <telerik:RadComboBox RenderMode="Lightweight" ID="rcbIsClosed" Skin="Bootstrap" 
                                runat="server" OnClientSelectedIndexChanged="TitleIndexChanged" >
                                <Items>
                                   <%-- <telerik:RadComboBoxItem  Text="<%$ Resources:ProjectManagementUI, UI_All1 %>" Value=""/>
                                    <telerik:RadComboBoxItem Text="<%$ Resources:ProjectManagementUI, Common_Yes %>" Value="Yes" />
                                    <telerik:RadComboBoxItem Text="<%$ Resources:ProjectManagementUI, Common_No %>" Value="No"/>--%>
                                </Items>
                            </telerik:RadComboBox>
                            <telerik:RadScriptBlock ID="RadScriptBlock1" runat="server">
                                <script type="text/javascript">
                                    
                                    function TitleIndexChanged(sender, args) {
                                        var tableView = $find("<%# ((GridItem)Container).OwnerTableView.ClientID %>");
                                        var hidenFieldComb = document.getElementById("MainContentPlaceHolder_Content_actControl_hdnIsFinishedCombo");
                                        
                                        hidenFieldComb.value = args.get_item().get_value();
                                        //alert(xCombo.Value);
                                        //alert(hidenFieldComb.value);
                                        if (args.get_item().get_value() == "Yes")
                                        {
                                            tableView.filter("IsClosed", true , "EqualTo");
                                        }
                                        else if (args.get_item().get_value() == "No")
                                        {
                                            tableView.filter("IsClosed", false, "EqualTo");
                                        }
                                        else {
                                            tableView.filter("IsClosed", "", "EqualTo");
                                        }
                                }
                                </script>
                            </telerik:RadScriptBlock>
                        </FilterTemplate>
			</telerik:GridTemplateColumn>
						
			<telerik:GridTemplateColumn AllowFiltering="false" HeaderStyle-Width="95" HeaderText="<%$ Resources:ProjectManagementUI, Common_Progres %>" UniqueName="ProgressColumn" AutoPostBackOnFilter="true" CurrentFilterFunction="StartsWith" SortExpression="Progress" >
				<ItemTemplate>
				    <div class="progress">
                        <div class="progress-bar bg-kendo-<%# Convert.ToInt32(Eval("Progress")) <= 20 ? "red" : "" %><%# Convert.ToInt32(Eval("Progress")) > 20  && Convert.ToInt32(Eval("Progress")) <= 99 ? "blue" : "" %><%# Convert.ToInt32(Eval("Progress")) > 99 ? "green" : "" %>" role="progressbar" aria-valuenow="<%# Eval("Progress") %>" aria-valuemin="0" aria-valuemax="100" style="width: <%# Eval("Progress") %>%">
                                <span class=""> <%# Eval("Progress") %>% </span>
                        </div>
                    </div> 
			    </ItemTemplate>
				<ItemStyle HorizontalAlign="Center" VerticalAlign="Middle" />
			</telerik:GridTemplateColumn>
			
				<telerik:GridTemplateColumn AllowFiltering="false" HeaderStyle-Width="30">
				<ItemTemplate>
					<div class="edit-button">
                        <a class="btn btn-xs btn-primary font-white" href="<%= getVirtualPath() %>/Pages/Activity.aspx?aid=<%# Eval("Id") %>"><i class="fa fa-edit"></i></a>
					</div>
				</ItemTemplate>
                <ItemStyle HorizontalAlign="Center" VerticalAlign="Middle" />
               
			</telerik:GridTemplateColumn>
        </Columns>
    </MasterTableView>
</telerik:RadGrid>
</telerik:RadAjaxPanel>
<telerik:RadAjaxLoadingPanel runat="server" ID="RadAjaxLoadingPanel1">
        <div class="updatePanelProgress">
            <asp:Literal ID="ltrPLeaseWait" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_PleaseWait %>" />...</div>
    </telerik:RadAjaxLoadingPanel>